# -*- coding: utf-8 -*-
"""
Created on Wed Oct 07 12:01:35 2015

"""

from CDomain import CDomain
from CRiver import CRiver
from CPollutant import CPollutant 
from CMixingParameters import CMixingParameters
from CModels import CModels
from CSpatialParameters import CSpatialParameters

import numpy as np

class CAnalysis:

    def __init__(self):
        self.Domain = CDomain()        
        self.River = CRiver()
        self.Pollutant = CPollutant()
        self.MixingParameters = CMixingParameters()
        self.Models = CModels()
        self.SpatialParameters = CSpatialParameters()
        self.Tau = 0
        self.TBar = 0
        #self.NumberOfRivers = 1
        
    def PrintToConsole(self):
        self.River.PrintToConsole()
        self.Pollutant.PrintToConsole()
        self.MixingParameters.PrintToConsole()        
        self.SpatialParameters.PrintToConsole()
        self.Domain.PrintToConsole()

        print ( 'Other parameters')
        print ( '----------------' )       
        print ( 'Tau %5.2f' % self.Tau)
        print ( 'TBar %5.2f' % self.TBar)
        print ( '')
       

    def NormalizationFactor(self):
        velocity = self.River.MeanVelocity
        dx = self.MixingParameters.Dx
        return velocity*velocity/dx
        #return 1.
    
    def Validate(self):
        width = self.River.Width
        y_range= self.Domain.Y.InclusiveRange()
        y_domain_max = y_range[-1]
        ymax = width/2.
        y_mid = self.Domain.Y.MidValue()
               
        if np.isclose(y_domain_max,ymax) and np.isclose(0.0, y_mid):
            return True
        else:
            return False
    
